/*
 *  Project: responsiveTabs.js
 *  Description: A plugin that creates responsive tabs, optimized for all devices
 *  Author: Jelle Kralt (jelle@jellekralt.nl)
 *  License: MIT
 */(function(e,t,n){function i(t,n){this.element=t;this.$element=e(t);this.tabs=[];this.state="";this.rotateInterval=0;this.options=e.extend({},r,n);this.init()}var r={collapsible:!1,startCollapsed:!1,rotate:!1,activate:function(){},deactivate:function(){},load:function(){},activateState:function(){},classes:{stateDefault:"r-tabs-state-default",stateActive:"r-tabs-state-active",tab:"r-tabs-tab",anchor:"r-tabs-anchor",panel:"r-tabs-panel",accordionTitle:"r-tabs-accordion-title"}};i.prototype.init=function(){var n=this;this.tabs=this.loadElements();this.loadClasses();this.loadEvents();e(t).on("resize",function(e){n.setState(e)});e(t).on("hashchange",function(e){var r=n.getTabRefBySelector(t.location.hash);r>=0&&n.openTab(e,n.getTab(r),!0)});this.options.rotate!==!1&&this.startRotation();this.$element.bind("tabs-activate",function(e){n.options.activate.call(this,e)});this.$element.bind("tabs-deactivate",function(e){n.options.deactivate.call(this,e)});this.$element.bind("tabs-load",function(e){var r=n.getTabRefBySelector(t.location.hash),i;n.setState(e);if(n.options.startCollapsed!==!0&&(n.options.startCollapsed!=="accordion"||n.state!=="accordion")){r>=0?i=n.getTab(r):i=n.getTab(0);n.openTab(e,i);n.options.load.call(this,e,i)}});this.$element.trigger("tabs-load")};i.prototype.loadElements=function(){var t=e("ul",this.$element),n=[];this.$element.addClass("r-tabs");t.addClass("r-tabs-nav");e("li",t).each(function(){var t=e(this),r=e("a",t),i=r[0].getAttribute("href"),s=e(i),o=e("<div></div>").insertBefore(s),u=e("<a></a>").attr("href",i).html(r.html()).appendTo(o),a={tab:e(this),anchor:e("a",t),panel:s,selector:i,accordionTab:o,accordionAnchor:u,active:!1};n.push(a)});return n};i.prototype.loadClasses=function(){for(var e=0;e<this.tabs.length;e++){this.tabs[e].tab.addClass(this.options.classes.stateDefault).addClass(this.options.classes.tab);this.tabs[e].anchor.addClass(this.options.classes.anchor);this.tabs[e].panel.addClass(this.options.classes.stateDefault).addClass(this.options.classes.panel);this.tabs[e].accordionTab.addClass(this.options.classes.accordionTitle);this.tabs[e].accordionAnchor.addClass(this.options.classes.anchor)}};i.prototype.loadEvents=function(){var e=this,t=function(t){var n=e.getCurrentTab();t.preventDefault();e.closeTab(t,n);(e.options.collapsible===!1||e.options.collapsible&&n!==t.data.tab)&&e.openTab(t,t.data.tab,!1,!0)};for(var n=0;n<this.tabs.length;n++){this.tabs[n].anchor.on("click",{tab:e.tabs[n]},t);this.tabs[n].accordionAnchor.on("click",{tab:e.tabs[n]},t)}};i.prototype.setState=function(t){var n=e("ul",this.$element),r=this.state;n.is(":visible")?this.state="tabs":this.state="accordion";this.state!==r&&this.$element.trigger("tabs-activate-state",t,{oldState:r,newState:this.state})};i.prototype.openTab=function(e,t,n,r){n&&this.closeTab(e,this.getCurrentTab());r&&this.rotateInterval>0&&this.stopRotation();t.active=!0;t.tab.removeClass(this.options.classes.stateDefault).addClass(this.options.classes.stateActive);t.panel.removeClass(this.options.classes.stateDefault).addClass(this.options.classes.stateActive);t.accordionTab.removeClass(this.options.classes.stateDefault).addClass(this.options.classes.stateActive);this.$element.trigger("tabs-activate",e,t)};i.prototype.closeTab=function(e,t){if(t!==n){t.active=!1;t.tab.removeClass(this.options.classes.stateActive).addClass(this.options.classes.stateDefault);t.panel.removeClass(this.options.classes.stateActive).addClass(this.options.classes.stateDefault);t.accordionTab.removeClass(this.options.classes.stateActive).addClass(this.options.classes.stateDefault);this.$element.trigger("tabs-deactivate",e,t)}};i.prototype.getTab=function(e){return this.tabs[e]};i.prototype.getTabRefBySelector=function(e){for(var t=0;t<this.tabs.length;t++)if(this.tabs[t].selector===e)return t;return-1};i.prototype.getCurrentTab=function(){return this.getTab(this.getCurrentTabRef())};i.prototype.getNextTabRef=function(){var e=this.getCurrentTabRef();return e===this.tabs.length-1?0:e+1};i.prototype.getPreviousTabRef=function(){var e=this.getCurrentTabRef();return e===0?this.tabs.length-1:e-1};i.prototype.getCurrentTabRef=function(){for(var e=0;e<this.tabs.length;e++)if(this.tabs[e].active)return e;return-1};i.prototype.startRotation=function(){var t=this;this.rotateInterval=setInterval(function(){var e=jQuery.Event("rotate");t.openTab(e,t.getTab(t.getNextTabRef()),!0)},e.isNumeric(t.options.rotate)?t.options.rotate:4e3)};i.prototype.stopRotation=function(){t.clearInterval(this.rotateInterval);this.rotateInterval=0};e.fn.responsiveTabs=function(t){var r=arguments;if(t===n||typeof t=="object")return this.each(function(){e.data(this,"responsivetabs")||e.data(this,"responsivetabs",new i(this,t))});if(typeof t=="string"&&t[0]!=="_"&&t!=="init")return this.each(function(){var n=e.data(this,"responsivetabs");n instanceof i&&typeof n[t]=="function"&&n[t].apply(n,Array.prototype.slice.call(r,1));t==="destroy"&&e.data(this,"responsivetabs",null)})}})(jQuery,window);
 
 
$(document).ready(function () {
$('#responsivetabs').responsiveTabs({
startCollapsed: false,
collapsible: 'accordion',
rotate: false,
setHash: true,
duration: 100,
animation: 'fade'
});
});